VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "WebBot"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum WebBotProvider
    KoGBot
End Enum

Public Ready As Boolean
Private ActionWaiting As Boolean, NextActionTime&
Private ConInfo$, bKey$, UEbKey$, WBType As WebBotProvider
Private HTTP As New WinHttpRequest, QueueActions As New Collection
Private Declare Function GetTickCount Lib "kernel32.dll" () As Long


Private Sub Class_Initialize()
    Ready = False
    ActionWaiting = False
    NextActionTime = GetTickCount()
End Sub

Public Function Initialize(WebBotType As WebBotProvider, ConnectInfo As String, BotKey$)
    WBType = WebBotType
    If WBType = KoGBot Then
        ConInfo = ConnectInfo
        bKey = BotKey
        UEbKey = UrlEncode(BotKey)
        Ready = True
        SendRequest "botid=" & UEbKey & "&action=addtext&text=" & _
            UrlEncode("<span style=""color: #00FFFF; font-weight: bold;"">" & _
                GetVersion() & "</span><br />")
    End If
End Function

Private Sub R(QueryString$, Optional ByVal Priority As Boolean = False)
    If Priority Then
        If QueueActions.Count() > 0 Then
            QueueActions.add QueryString, , 1
            ActionWaiting = True
        Else
            SendRequest QueryString
        End If
    Else
        QueueActions.add QueryString
        ActionWaiting = True
    End If
End Sub

Public Function IsActionWaiting() As Boolean
    'Debug.Print NextActionTime & " " & GetTickCount()
    If ActionWaiting = True And GetTickCount() >= NextActionTime Then
        IsActionWaiting = True
    Else
        IsActionWaiting = False
    End If
End Function

Public Function GetNextAction() As String
    Dim C&
    C = QueueActions.Count()
    If C > 0 Then
        NextActionTime = GetTickCount() + 100
        GetNextAction = QueueActions(1)
        QueueActions.Remove 1
        If C = 1 Then ActionWaiting = False
    End If
End Function

Public Sub SendRequest(Optional ByVal QueryString$ = "")
    If LenB(QueryString) = 0 And ActionWaiting Then
        QueryString = GetNextAction()
        If LenB(QueryString) = 0 Then
            ActionWaiting = False
            Exit Sub
        End If
    End If
    HTTP.Open "GET", ConInfo & "?" & QueryString, True
    HTTP.Send
End Sub

Private Function UrlEncode(ByVal urlText As String) As String
    Dim i As Long
    Dim ansi() As Byte
    Dim ascii As Integer
    Dim encText As String

    ansi = StrConv(urlText, vbFromUnicode)

    encText = ""
        For i = 0 To UBound(ansi)
        ascii = ansi(i)

        Select Case ascii
        Case 48 To 57, 65 To 90, 97 To 122
            encText = encText & Chr(ascii)

        Case 32
            encText = encText & "+"

        Case Else
            If ascii < 16 Then
                encText = encText & "%0" & Hex(ascii)
            Else
                encText = encText & "%" & Hex(ascii)
            End If

        End Select
    Next i
    
    UrlEncode = encText
End Function

Public Sub UserPresent(Username$, Client$, Flags&, Ping&)
    If WBType = KoGBot Then
        Dim T$
        Username = Replace(Username, "<", "&lt;")
        Username = Replace(Username, ">", "&gt;")
        R "botid=" & UEbKey & "&action=adduser&username=" & UrlEncode(Username) & _
            "&product=" & StrReverse(Client) & "&flags=" & Flags & "&ping=" & Ping
        T = KoGTimestamp() & "<span style=""color: white;"">User " & Username & _
            " is in the channel using " & _
            ClientKeyToName(ClientStrToKey(Client)) & " with a ping of " & Ping & "ms.</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub UserJoin(Username$, Client$, Flags&, Ping&)
    If WBType = KoGBot Then
        Dim T$
        Username = Replace(Username, "<", "&lt;")
        Username = Replace(Username, ">", "&gt;")
        R "botid=" & UEbKey & "&action=adduser&username=" & UrlEncode(Username) & _
            "&product=" & StrReverse(Client) & "&flags=" & Flags & "&ping=" & Ping
        T = KoGTimestamp() & "<span style=""color: lime;"">User " & Username & _
            " entered the channel using " & _
            ClientKeyToName(ClientStrToKey(Client)) & " with a ping of " & Ping & "ms.</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub UserLeave(Username$)
    If WBType = KoGBot Then
        Dim T$
        Username = Replace(Username, "<", "&lt;")
        Username = Replace(Username, ">", "&gt;")
        R "botid=" & UEbKey & "&action=remuser&username=" & UrlEncode(Username)
        T = KoGTimestamp() & "<span style=""color: red;"">User " & Username & " has left the channel.</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub UserFlags(Username$, Flags&)
    If WBType = KoGBot Then
        Username = Replace(Username, "<", "&lt;")
        Username = Replace(Username, ">", "&gt;")
        R "botid=" & UEbKey & "&action=edituser&username=" & UrlEncode(Username) & _
            "&flags=" & Flags
    End If
End Sub

Public Sub UserSays(Username$, Text$, Flags&)
    Dim T$
    If WBType = KoGBot Then
        Username = Replace(Username, "<", "&lt;")
        Username = Replace(Username, ">", "&gt;")
        Text = Replace(Text, "<", "&lt;")
        Text = Replace(Text, ">", "&gt;")
        If Flags And USER_CHANNELOP Then
            T = KoGTimestamp() & "<span style=""color: white;"">"
        Else
            T = KoGTimestamp() & "<span style=""color: yellow;"">"
        End If
        T = T & "&lt;" & Username & "&gt;</span> <span style=""color: white;"">" _
            & Text & "</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub BotSays(Username$, Text$)
    Dim T$
    Username = Replace(Username, "<", "&lt;")
    Username = Replace(Username, ">", "&gt;")
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        T = KoGTimestamp() & "<span style=""color: #00DDFF;"">&lt;" & Username & "&gt;</span> " & _
            "<span style=""color: white;"">" & Text & "</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub UserEmote(Username$, Text$, Flags&)
    Dim T$
    Username = Replace(Username, "<", "&lt;")
    Username = Replace(Username, ">", "&gt;")
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        If Flags And USER_CHANNELOP Then
            T = KoGTimestamp() & "<span style=""color: white;"">"
        Else
            T = KoGTimestamp() & "<span style=""color: yellow;"">"
        End If
        T = T & "&lt;" & Username & " " & Text & "&gt;</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub WhisperRecv(Username$, Text$)
    Dim T$
    Username = Replace(Username, "<", "&lt;")
    Username = Replace(Username, ">", "&gt;")
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        T = KoGTimestamp() & "<span style=""color: #6082B8;"">&lt;From: " & Username & "&gt;</span> " & _
            "<span style=""color: silver;"">" & Text & "</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub WhisperSend(Username$, Text$)
    Dim T$
    Username = Replace(Username, "<", "&lt;")
    Username = Replace(Username, ">", "&gt;")
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        T = KoGTimestamp() & "<span style=""color: #6082B8;"">&lt;To: " & Username & "&gt;</span> " & _
            "<span style=""color: silver;"">" & Text & "</span>"
        R "botid=" & UEbKey & "&action=addtext&text=" & UrlEncode(T)
    End If
End Sub

Public Sub BNInfo(Text$)
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        R "botid=" & UEbKey & "&action=addtext&text=" & KoGTimestamp() & _
            UrlEncode("<span style=""color: yellow;"">" & Text & "</span>")
    End If
End Sub

Public Sub BNError(Text$)
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        R "botid=" & UEbKey & "&action=addtext&text=" & KoGTimestamp() & _
            UrlEncode("<span style=""color: red;"">" & Text & "</span>")
    End If
End Sub

Public Sub BNBroadcast(Text$)
    Text = Replace(Text, "<", "&lt;")
    Text = Replace(Text, ">", "&gt;")
    If WBType = KoGBot Then
        R "botid=" & UEbKey & "&action=addtext&text=" & KoGTimestamp() & _
            UrlEncode("<span style=""color: yellow;"">Broadcast: " & Text & "</span>")
    End If
End Sub

Public Sub JoinChannel(Channel$)
    Channel = Replace(Channel, "<", "&lt;")
    Channel = Replace(Channel, ">", "&gt;")
    If WBType = KoGBot Then
        R "botid=" & UEbKey & "&action=channel&channel=" & UrlEncode(Channel), True
        R "botid=" & UEbKey & "&action=addtext&text=" & KoGTimestamp() & _
            UrlEncode("<span style=""color: white;"">Joined channel: " & Channel & "</span>")
    End If
End Sub

Private Function KoGTimestamp() As String
    KoGTimestamp = "<span style=""color: white;"">[" & _
        Format(Time, "h:mm:ss AM/PM") & "] </span>"
End Function

